<?php

namespace Modules\SupportTicket\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class SupportTicketCreateRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'subject' => 'required',
            'description' => 'required',
            'ticket_file.*' => 'nullable|mimes:jpg,jpeg,bmp,png,doc,docx,csv,rtf,xlsx,xls,txt,pdf',
            'refer_id' => 'nullable',
            'priority_id' => 'required',
            'category_id' => 'required',
            'status' => 'required'
            
        ];
    }
    public function messages()
    {
        return [
            'ticket_file.*.mimes' => 'The ticket file must be a file of type: jpg, jpeg, bmp, png, doc, docx, csv, rtf, xlsx, xls, txt, pdf.',
        ];
    }
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }
}
