<?php

namespace Tests\Browser\Modules\Customer;

use App\Models\User;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\WithFaker;
use Laravel\Dusk\Browser;
use Tests\DuskTestCase;

class CustomerListTest extends DuskTestCase
{
    use WithFaker;

    protected $customer = [];

    public function setUp(): void
    {
        parent::setUp();


    }

    public function tearDown(): void
    {
        $customer = User::where('role_id', 4)->first();
        $customer->update([
            'is_active' => 1
        ]);

        parent::tearDown(); // TODO: Change the autogenerated stub
    }

    /**
     * A Dusk test example.
     *@test
     * @return void
     */
    public function for_visit_index_page()
    {
        $this->browse(function (Browser $browser) {
            $browser->loginAs(1)
                ->visit('/customer/active-customer-list')
                ->assertSee('Active Customer');
        });
    }

    /**
     * @test
     */
    public function for_tab_to_inactive_list(){
        $this->for_visit_index_page();

        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > section > div > div > div.col-md-12.mb-20 > div > div > ul > li:nth-child(2)')
                ->waitForText('In active customer', 3)
                ->assertSee('In active customer');
        });
    }

    /**
     * @test
     */

     public function for_visit_customer_details(){
        $this->for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $customer = User::where('role_id', 4)->first();
            $browser->waitFor('#activeCustomerTable > tbody > tr:nth-child(1) > td:nth-child(9) > div > button', 25)
                ->click('#activeCustomerTable > tbody > tr:nth-child(1) > td:nth-child(9) > div >button')
                ->click('#activeCustomerTable > tbody > tr:nth-child(1) > td:nth-child(9) > div > div > a')
                ->assertPathIs('/customer/profile/details/'.$customer->id)
                ->assertSee('Customer Profile');
        });
     }
     /**
      * @test
      */

     public function for_disable_customer_and_checklist(){
        $this->for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->waitFor('#activeCustomerTable > tbody > tr:nth-child(1) > td:nth-child(6) > label > div', 25)
                ->click('#activeCustomerTable > tbody > tr:nth-child(1) > td:nth-child(6) > label > div')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!')
                ->pause(5000)
                ->click('#main-content > section > div > div > div.col-md-12.mb-20 > div > div > ul > li:nth-child(2)')
                ->waitForText('In active customer', 3)
                ->assertSee('In active customer')
                ->pause(5000)
                ->waitFor('#inactiveCustomerTable > tbody > tr > td:nth-child(9) > div > button', 25)
                ->assertSeeAnythingIn('#inactiveCustomerTable > tbody > tr > td:nth-child(9) > div > button');
        });
     }

     
}
