<?php

namespace Tests\Browser\Modules\Seller;

use App\Models\User;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\WithFaker;
use Illuminate\Support\Facades\File;
use Laravel\Dusk\Browser;
use Tests\DuskTestCase;

class SubSellerTest extends DuskTestCase
{
    use WithFaker;

    public function setUp(): void
    {
        parent::setUp();


    }

    public function tearDown(): void
    {
        $sellers = User::where('id', '>', 5)->where('role_id', 6)->get();
        if(count($sellers) > 0){
            foreach($sellers as $seller){
                if(File::exists(public_path($seller->avatar))){
                    File::delete(public_path($seller->avatar));
                }
                $seller->sub_seller->delete();
                $seller->delete();
            }
        }

        parent::tearDown(); // TODO: Change the autogenerated stub
    }

    /**
     * A Dusk test example.
     *
     * @return void
     */
    public function test_for_visit_index_page()
    {
        $this->browse(function (Browser $browser) {
            $browser->loginAs(5)
                ->visit('/seller/my-staff')
                ->assertSee('My Staff');
        });
    }

    public function test_for_create_subseller(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > section > div > div > div.col-12 > div > div > ul > li > a')
                ->assertPathIs('/seller/my-staff-create')
                ->assertSee('Create A Staff')
                ->type('#staff_addForm > div > div:nth-child(3) > div > input', $this->faker->name)
                ->type('#staff_addForm > div > div:nth-child(3) > div > input', $this->faker->name)
                ->type('#staff_addForm > div > div:nth-child(5) > div > input', $this->faker->email)
                ->type('#password', '12345678')
                ->type('#re_password', '12345678')
                ->type('#phone', $this->faker->phoneNumber)
                ->type('#address', 'test address')
                ->attach('#document_file_1', __DIR__.'/files/avatar.jpg')
                ->click('#save_button_parent')
                ->assertPathIs('/seller/my-staff')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Added successfully!');

        });
    }

    public function test_for_validate_create_form(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > section > div > div > div.col-12 > div > div > ul > li > a')
                ->assertPathIs('/seller/my-staff-create')
                ->assertSee('Create A Staff')
                ->click('#save_button_parent')
                ->assertPathIs('/seller/my-staff-create')
                ->assertSeeIn('#staff_addForm > div > div:nth-child(3) > div > span', 'This Name Filed is required')
                ->assertSeeIn('#staff_addForm > div > div:nth-child(5) > div > span', 'This Email is required')
                ->assertSeeIn('#staff_addForm > div > div:nth-child(6) > div > span', 'This Password Filed is required')
                ->type('#staff_addForm > div > div:nth-child(5) > div > input', 'seller@gmail.com')
                ->type('#password', '12345678')
                ->click('#save_button_parent')
                ->assertPathIs('/seller/my-staff-create')
                ->assertSeeIn('#staff_addForm > div > div:nth-child(5) > div > span', 'Email has already taken')
                ->assertSeeIn('#staff_addForm > div > div:nth-child(6) > div > span', 'The password confirmation does not match.');

                
        });
    }

    public function test_for_edit_subseller(){
        $this->test_for_create_subseller();
        $this->browse(function (Browser $browser) {
            $user = User::latest()->first();
            $browser->click('#DataTables_Table_0 > tbody > tr > td:nth-child(6) > div > button')
                ->click('#DataTables_Table_0 > tbody > tr > td:nth-child(6) > div > div > a:nth-child(1)')
                ->assertPathIs('/seller/my-staff-edit/'.$user->id)
                ->assertSee('Update staff info')
                ->type('#main-content > section > div > div > div:nth-child(2) > div > form > div > div:nth-child(3) > div > input', $this->faker->name)
                ->type('#main-content > section > div > div > div:nth-child(2) > div > form > div > div:nth-child(4) > div > input', $this->faker->name)
                ->type('#password', '123456789')
                ->type('#re_password', '123456789')
                ->type('#phone', $this->faker->phoneNumber)
                ->type('#address', 'test address edit')
                ->attach('#document_file_1', __DIR__.'/files/avatar.jpg')
                ->click('#save_button_parent')
                ->assertPathIs('/seller/my-staff')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });
    }

    public function test_for_validate_edit_form(){
        $this->test_for_create_subseller();
        $this->browse(function (Browser $browser) {
            $user = User::latest()->first();
            $browser->click('#DataTables_Table_0 > tbody > tr > td:nth-child(6) > div > button')
                ->click('#DataTables_Table_0 > tbody > tr > td:nth-child(6) > div > div > a:nth-child(1)')
                ->assertPathIs('/seller/my-staff-edit/'.$user->id)
                ->assertSee('Update staff info')
                ->type('#main-content > section > div > div > div:nth-child(2) > div > form > div > div:nth-child(3) > div > input', '')
                ->type('#main-content > section > div > div > div:nth-child(2) > div > form > div > div:nth-child(4) > div > input', '')
                ->type('#password', '')
                ->type('#re_password', '')
                ->type('#phone', '')
                ->type('#address', '')
                ->click('#save_button_parent')
                ->assertPathIs('/seller/my-staff-edit/'.$user->id)
                ->assertSeeIn('#main-content > section > div > div > div:nth-child(2) > div > form > div > div:nth-child(3) > div > span', 'The first name field is required.');
                
        });
    }


    public function test_for_give_permission(){
        $this->test_for_create_subseller();
        $this->browse(function (Browser $browser) {
            $user = User::latest()->first();
            $browser->click('#DataTables_Table_0 > tbody > tr > td:nth-child(6) > div > button')
                ->click('#DataTables_Table_0 > tbody > tr > td:nth-child(6) > div > div > a:nth-child(2)')
                ->assertPathIs('seller/my-staff-access-permission/'. $user->id)
                ->assertSeeAnythingIn('#main-content > div.role_permission_wrap > div > h4')
                ->click('#\31 6 > div.permission_header.d-flex.align-items-center.justify-content-between > div.arrow.collapsed')
                ->pause(1000)
                ->click('#Role16 > div > ul > li:nth-child(1) > div > label')
                ->click('#Role16 > div > ul > li:nth-child(2) > div > label')
                ->click('#Role16 > div > ul > li:nth-child(3) > div > label')
                ->pause(1000)
                ->click('#main-content > form > div > div.row.mt-40 > div > button')
                ->assertPathIs('seller/my-staff-access-permission/'. $user->id)
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Permission given successfully.');

        });
    }

    public function test_for_delete_subseller(){
        $this->test_for_create_subseller();
        $this->browse(function (Browser $browser) {
            $user = User::latest()->first();
            $browser->click('#DataTables_Table_0 > tbody > tr > td:nth-child(6) > div > button')
                ->click('#DataTables_Table_0 > tbody > tr > td:nth-child(6) > div > div > a:nth-child(3)')
                ->whenAvailable('#confirm-delete > div > div > div.modal-body > div.mt-40.d-flex.justify-content-between', function($modal){
                    $modal->click('#delete_link')
                        ->assertPathIs('/seller/my-staff');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Deleted successfully!');

        });
    }


}
