<?php

namespace Tests\Browser\Modules\Setup;

use App\Models\User;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\WithFaker;
use Illuminate\Support\Facades\File;
use Laravel\Dusk\Browser;
use Modules\Setup\Entities\Country;
use Tests\DuskTestCase;

class CountryTest extends DuskTestCase
{
    use WithFaker;

    public function setUp(): void
    {
        parent::setUp();


    }

    public function tearDown(): void
    {
        $countries = Country::where('id', '>', 246)->get();
        foreach($countries as $country){
            if(File::exists(public_path($country->flag)) && $country->flag != null){
                File::delete(public_path($country->flag));
            }
            $country->delete();
        }

        parent::tearDown(); // TODO: Change the autogenerated stub
    }

    /**
     * A Dusk test example.
     *
     * @return void
     */
    public function test_for_visit_index_page()
    {
        $this->browse(function (Browser $browser) {
            $user = User::find(1);
            $browser->loginAs($user)
                    ->visit('/setup/location/country')
                    ->assertSee('Country List');
        });
    }

    public function test_for_create_country(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->type('#name', 'test country')
                ->type('#code', substr($this->faker->slug, 0, 5))
                ->type('#phonecode', rand(1111,9999))
                ->attach('#flag', __DIR__.'/files/favicon.png')
                ->click('#create_form > div > div > div.col-lg-12.text-center > div > button')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Added successfully!');
        });
    }

    public function test_for_validate_create_country(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#create_form > div > div > div.col-lg-12.text-center > div > button')
                ->waitForTextIn('#error_name', 'The name field is required.',25)
                ->waitForTextIn('#error_code', 'The code field is required.',25)
                ->waitForTextIn('#error_phonecode', 'The phonecode field is required.',25);
        });
    }

    public function test_for_edit_country(){
        $this->test_for_create_country();
        $this->browse(function (Browser $browser) {
            $browser->type('#DataTables_Table_1_filter > label > input[type=search]', 'test country')
                ->pause(2000)
                ->assertSeeIn('#DataTables_Table_1 > tbody > tr:nth-child(1) > td:nth-child(2)', 'test country')
                ->click('#DataTables_Table_1 > tbody > tr:nth-child(1) > td:nth-child(7) > div > button')
                ->click('#DataTables_Table_1 > tbody > tr:nth-child(1) > td:nth-child(7) > div > div > a')
                ->waitFor('#edit_form', 25)
                ->type('#name', 'test country edit')
                ->type('#code', substr($this->faker->slug, 0, 5))
                ->type('#phonecode', rand(1111,9999))
                ->attach('#flag', __DIR__.'/files/favicon.png')
                ->click('#edit_form > div > div > div.col-lg-12.text-center > div > button')
                ->pause(5000)
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });
    }

    public function test_for_validate_edit_country(){
        $this->test_for_create_country();
        $this->browse(function (Browser $browser) {
            $browser->type('#DataTables_Table_1_filter > label > input[type=search]', 'test country')
                ->pause(2000)
                ->assertSeeIn('#DataTables_Table_1 > tbody > tr:nth-child(1) > td:nth-child(2)', 'test country')
                ->click('#DataTables_Table_1 > tbody > tr:nth-child(1) > td:nth-child(7) > div > button')
                ->click('#DataTables_Table_1 > tbody > tr:nth-child(1) > td:nth-child(7) > div > div > a')
                ->waitFor('#edit_form', 25)
                ->type('#name', '')
                ->type('#code', '')
                ->type('#phonecode', '')
                ->click('#edit_form > div > div > div.col-lg-12.text-center > div > button')
                ->waitForTextIn('#error_name', 'The name field is required.',25)
                ->waitForTextIn('#error_code', 'The code field is required.',25)
                ->waitForTextIn('#error_phonecode', 'The phonecode field is required.',25);
        });
    }

    public function test_for_status_change(){
        $this->test_for_create_country();
        $this->browse(function (Browser $browser) {
            $browser->type('#DataTables_Table_1_filter > label > input[type=search]', 'test country')
                ->pause(2000)
                ->assertSeeIn('#DataTables_Table_1 > tbody > tr:nth-child(1) > td:nth-child(2)', 'test country')
                ->click('#DataTables_Table_1 > tbody > tr:nth-child(1) > td:nth-child(6) > label > div')
                ->pause(5000)
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });
        
    }
}
