<?php

namespace Tests\Browser\Modules\Wallet;

use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\WithFaker;
use Laravel\Dusk\Browser;
use Modules\Wallet\Entities\WalletBalance;
use Tests\DuskTestCase;

class WalletManageTest extends DuskTestCase
{
    use WithFaker;


    public function setUp(): void
    {
        parent::setUp();

    }

    public function tearDown(): void
    {
        $balances = WalletBalance::all();
        foreach($balances as $balance){
            $balance->delete();
        }

        parent::tearDown(); // TODO: Change the autogenerated stub
    }

    /**
     * A Dusk test example.
     *
     * @return void
     */
    public function test_for_visit_wallet_recharge_approval()
    {
        $this->browse(function (Browser $browser) {
            $browser->loginAs(1)
                    ->visit('/wallet/recharge-requests')
                    ->assertSee('Wallet Recharge Transactions');
        });
    }

    public function test_for_offline_recharge(){
        $this->test_for_visit_wallet_recharge_approval();
        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > section > div > div > div > div.box_header.common_table_header > div > ul > li > a')
                ->whenAvailable('#Recharge_Modal_Offline > div > div > div.modal-body > form', function($modal){
                    $modal->click('div > div:nth-child(1) > div > div')
                        ->click('div > div:nth-child(1) > div > div > ul > li:nth-child(2)')
                        ->type('div > div:nth-child(2) > div > input', '200')
                        ->type('div > div:nth-child(3) > div > textarea', $this->faker->paragraph)
                        ->click('div > div.col-lg-12.text-center > div > button')
                        ->assertPathIs('/wallet/recharge-requests');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Recharged Successfully');
        });
    }

    public function test_for_test_for_approve_recharge(){
        WalletBalance::create([
            'user_id' => 5,
            'type' => "Deposite",
            'amount' => 200,
            'payment_method' => 4,
            'txn_id' => 'ch_1J9Pk9GRvmmDdlLV1ogZNRr2',
            'status' => 0
        ]);
        $this->test_for_visit_wallet_recharge_approval();
        $this->browse(function (Browser $browser) {
            $browser->waitFor('#walletTable > tbody > tr.odd > td:nth-child(8) > label > div')
                ->click('#walletTable > tbody > tr.odd > td:nth-child(8) > label > div')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Approved Successfully.');

        });
    }

    public function test_for_withdraw_request_visit(){
        $this->browse(function (Browser $browser) {
            $browser->loginAs(1)
                ->visit('/wallet/withdraw-requests')
                ->assertSee('Withdraw Requests');
        });
    }

    public function test_for_view_withdraw_request(){
        WalletBalance::create([
            'user_id' => 5,
            'type' => 'Withdraw',
            'amount' => 100,
            'payment_method' => 7,
            'txn_id' => "None",
            'status' => 0,
        ]);
        $this->test_for_withdraw_request_visit();
        $this->browse(function (Browser $browser) {
            $browser->waitFor('#withdrawTable > tbody > tr > td:nth-child(9) > a', 25)
                ->click('#withdrawTable > tbody > tr > td:nth-child(9) > a')
                ->pause(10000)
                ->whenAvailable('#Withdraw_Modal > div > div', function($modal){
                    $modal->assertSeeIn('div.modal-header > h4', 'Details Info');
                });

        });
    }

    public function test_for__visit_offline_recharge(){
        $this->browse(function (Browser $browser) {
            $browser->loginAs(1)
                ->visit('wallet/recharge-offline-index')
                ->assertSee('Offline Recharge')
                ->click('#main-content > section > div > div > div > div.box_header.common_table_header > div > ul > li > a')
                ->whenAvailable('#Recharge_Modal_Offline > div > div > div.modal-body > form', function($modal){
                    $modal->click('div > div:nth-child(1) > div > div')
                        ->click('div > div:nth-child(1) > div > div > ul > li:nth-child(1)')
                        ->type('div > div:nth-child(2) > div > input','200')
                        ->type('div > div:nth-child(3) > div > textarea', $this->faker->paragraph)
                        ->click('div > div.col-lg-12.text-center > div > button')
                        ->assertPathIs('/wallet/recharge-offline-index');

                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Recharged Successfully');
        });
    }

    


}
